import React, {Fragment} from "react";
import "@grapecity/activereports-localization-zh";
import ReactDOM from "react-dom";
import {Viewer as ReportViewer} from "@grapecity/activereports-react";
import "@grapecity/activereports-localization";

function App() {
    const viewer = React.useRef();

    // 打印
    function print() {
        viewer.current.print();
    }
    return (
        <Fragment>
            <div style={{padding:"10px"}}>
                <button onClick={print}>打印</button>
            </div>
            <div id="viewer-host" style={{height: "800px"}}>
                <ReportViewer report={
                    {
                        Uri: "reports/p-report.rdlx-json",
                        Params: {"P1": "1"}
                    }
                } ref={viewer} language={"zh"}/>
            </div>
        </Fragment>
    );
}

ReactDOM.render(<App/>, document.getElementById("root"));

