import React, {Fragment} from "react";
import "@grapecity/activereports-localization-zh";
import ReactDOM from "react-dom";
import {Viewer as ReportViewer} from "@grapecity/activereports-react";
import "@grapecity/activereports-localization";

function App() {
    const viewer = React.useRef();
    React.useEffect(() => {
        if (!viewer.current) return;

        // //隐藏侧边栏
        // viewer.current.Viewer.toggleSidebar(false);
        // //隐藏整个工具栏
        // viewer.current.Viewer.toggleToolbar(false);
    }, []);
    return (
        <Fragment>
            <div id="viewer-host" style={{height: "800px"}}>
                <ReportViewer report={
                    {
                        Uri: "reports/p-report.rdlx-json",
                        Params: {"P1": "1"}
                    }
                } ref={viewer} language={"zh"}/>
            </div>
        </Fragment>
    );
}

ReactDOM.render(<App/>, document.getElementById("root"));

